package com.icetech.common.domain;

import com.icetech.common.domain.request.P2cBaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * Description P2CMessage
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/5/6 4:52 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class P2cBaseMsg<T> extends P2cBaseRequest<T> {

    /**
     * 产品KEY
     */
    private String productKey;
    /**
     * 模块
     */
    private String module;
    
    /**
     * 设备号
     */
    private String sn;

    /**
     * code
     */
    private Integer code;

    /**
     * msg
     */
    private String msg;

    /**
     * 响应数据
     */
    private T data;

    /**
     * 原始参数
     */
    private String sourceParam;

    /**
     * 协议，1-WS, 2-IOT
     */
    private Integer protocolType;
    
    /**
     * 版本号
     */
    private String version;

}
