package com.icetech.common.content;

import com.alibaba.ttl.TransmittableThreadLocal;

import java.util.function.Supplier;

/**
 * Description TenantContextHolder
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2020/4/8 8:55 PM
 */
public class TenantContextHolder {

    /**
     * 支持父子线程之间的数据传递
     */
    private static final ThreadLocal<String> CONTEXT = new TransmittableThreadLocal<>();

    public static void setTenantId(String tenantId) {
        CONTEXT.set(tenantId);
    }

    public static String getTenantId() {
        return CONTEXT.get();
    }

    public static void clear() {
        CONTEXT.remove();
    }

    /**
     * 设置租户ID，并执行回调函数
     *
     * @param tenantId  租户 id
     * @param supplier  执行任务
     * @param <T>   返回值
     * @return T
     */
    public static <T> T setAndClearTenantId(String tenantId, Supplier<T> supplier) {
        try {
            setTenantId(tenantId);
            return supplier.get();
        } finally {
            clear();
        }
    }
}
