package com.icetech.common.constants;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZoneOffset;

/**
 * 系统默认值
 */
public class SystemConstants {
    /**
     * 默认字符编码
     */
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    /**
     * 默认字符编码
     */
    public static final String DEFAULT_CHARSET_NAME = DEFAULT_CHARSET.name();

    /**
     * 默认时区
     */
    public static final String DEFAULT_OFFSET = "+8";
    /**
     * 默认时区
     */
    public static final ZoneOffset DEFAULT_ZONE_OFFSET = ZoneOffset.of(DEFAULT_OFFSET);
    /**
     * 默认时区
     */
    public static final ZoneId DEFAULT_ZONE_ID = ZoneId.of(DEFAULT_OFFSET);
}
