package com.icetech.common.constants;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.io.Serializable;

/**
 * 平台支持的支付类型
 * @author wangzw
 * @since 迁移到支付中心
 */
@AllArgsConstructor
@Deprecated
public enum PlatformPayType implements Serializable {


    WX_ALI_PAY("WX_ALI_PAY","微信支付宝直连支付类型","WX-JSAPI/ALI-JSAPI/WX-MINI/ALI-MINI","WX-MICRO/ALI-MICRO",-1),
    CCB_PAY("CCB_PAY","建设银行聚合支付","CCB-QRCODE","CCB-SCAN",3),
    ABC_PAY("ABC_PAY","农业银行聚合支付","ABC-QRCODE","ABC-SCAN",4),
    YZ_PAY("YZ_PAY","云纵聚合支付","YZ-JSAPI/YZ-MINI","YZ-SCAN",5),
    GS_PAY("GANSU_PAY","甘肃银行聚合支付","GANSU-JSAPI","GANSU-SCAN",7),
    FJ_PAY("FJ_PAY","福建农商行聚合支付","FJ-QRCODE","",8),
    ICBC_PAY("ICBC_PAY","工商银行聚合支付","ICBC-QRCODE","",9),
    LANZHOU_PAY("LANZHOU_PAY","兰州银行聚合支付","LANZHOU-QRCODE","",10),
    COPS_PAY("COPS_PAY","广发银行聚合支付","COPS-QRCODE","COPS-SCAN",11),
    WLK_PAY("WLK_PAY","网联客聚合支付","WLK-QRCODE","WLK-SCAN",12),
    ZJ_PAY("ZJ_PAY","浙江农商行聚合支付","ZJ-QRCODE","ZJ-SCAN",13),


    NO_SEN_PARKING_PAY("NO_SEN_PARKING_PAY","阿里平台无感支付","","",-1),
    NO_SEN_UNION_PAY("NO_SEN_UNION_PAY","银联无感支付","","",-1),
    NO_SEN_CCB_PAY("NO_SEN_CCB_PAY","建行无感支付","","",-1),
    NO_SEN_GANSU_PAY("NO_SEN_GANSU_PAY","甘肃银行无感支付","","",-1),
    NO_SEN_ZFB_PAY("NO_SEN_ZFB_PAY","支付宝无感支付","","",-1),
    NO_SEN_ICBC_PAY("NO_SEN_ICBC_PAY","工商银行无感支付","","",-1),

    @Deprecated
    NO_SEN_ABC_PAY("NO_SEN_ABC_PAY","农行无感支付","","",-1),

    @Deprecated
    CMBC_PAY("CMBC_PAY","民生银行聚合支付","QRCODE-QRCODE","",-1),

    @Deprecated
    PARKING_PAY("PARKING_PAY","阿里平台聚合支付","","",6),

    ;
    /**
     * 平台对应编码
     */
    private @Getter String code;
    /**
     * 描述
     */
    private @Getter String desc;
    /**
     * 正扫下单类型
     */
    private @Getter String tradeType;
    /**
     * 反扫下单类型
     */
    private @Getter String tradeTypeScan;
    /**
     * 支付渠道
     */
    private @Getter Integer  payAisle;

    public static PlatformPayType getByCode(String code){
        for (PlatformPayType payType:PlatformPayType.values()){
            if (payType.getCode().equals(code)){
                return payType;
            }
        }
        return null;
    }

    public static String getTradeType(String code,Integer payWay){
        for (PlatformPayType payType:PlatformPayType.values()){
            if (payType.getCode().equals(code)){
                if (payType.equals(WX_ALI_PAY)){
                    if (PayMethodContants.ALIPAY_APPLETS.equals(payWay)){
                        return payType.getTradeType().split("/")[3];
                    }
                    if (PayMethodContants.WECHAT_APPLETS.equals(payWay)){
                        return payType.getTradeType().split("/")[2];
                    }
                    if (PayMethodContants.ALIPAY.equals(payWay)){
                        return payType.getTradeType().split("/")[1];
                    }
                    if (PayMethodContants.WECHAT.equals(payWay)){
                        return payType.getTradeType().split("/")[0];
                    }
                }

                if (payType.equals(YZ_PAY)){
                    if (PayMethodContants.ALIPAY_APPLETS.equals(payWay)){
                        return payType.getTradeType().split("/")[1];
                    }
                    if (PayMethodContants.WECHAT_APPLETS.equals(payWay)){
                        return payType.getTradeType().split("/")[1];
                    }
                    if (PayMethodContants.ALIPAY.equals(payWay)){
                        return payType.getTradeType().split("/")[0];
                    }
                    if (PayMethodContants.WECHAT.equals(payWay)){
                        return payType.getTradeType().split("/")[0];
                    }
                    if (PayMethodContants.UNIONPAY.equals(payWay)){
                        return payType.getTradeType().split("/")[0];
                    }
                }
                return payType.getTradeType();
            }
        }
        return null;
    }


    public static String getTradeTypeScan(String code,Integer payWay){
        for (PlatformPayType payType:PlatformPayType.values()){
            if (payType.getCode().equals(code)){
                if (payType.equals(WX_ALI_PAY)){
                    if (PayMethodContants.ALIPAY.equals(payWay)){
                        return payType.getTradeTypeScan().split("/")[1];
                    }
                    if (PayMethodContants.WECHAT.equals(payWay)){
                        return payType.getTradeTypeScan().split("/")[0];
                    }

                }
                return payType.getTradeTypeScan();
            }
        }
        return null;
    }

    public static Integer getPayAisle(String code,Integer payWay){
        for (PlatformPayType payType:PlatformPayType.values()){
            if (payType.getCode().equals(code)){
                if (payType.equals(WX_ALI_PAY)){
                    if (PayMethodContants.ALIPAY.equals(payWay)){
                        return PayAisleEnum.ALI.getType();
                    }
                    if (PayMethodContants.WECHAT.equals(payWay)){
                        return PayAisleEnum.WX.getType();
                    }
                }
                return payType.getPayAisle();
            }
        }
        return -1;
    }
}
