package com.icetech.common.constants;

import java.util.HashMap;
import java.util.Map;

public class OrderCarInfoConstant {
    /**
     * 进出场方式：车牌识别
     */
    public static final int IN_OUT_WAY_PLATE_NUM = 1;
    /**
     * 进出场方式：遥控器抬杆
     */
    public static final int IN_OUT_WAY_REMOTE_CONTROL = 2;
    /**
     * 进出场方式：无牌车扫码
     */
    public static final int IN_OUT_WAY_QR_CODE = 3;
    /**
     * 进出场方式：软件人工
     */
    public static final int IN_OUT_WAY_SOFTWARE_MANUAL = 4;
    /**
     * 进出场方式：断电应急
     */
    public static final int IN_OUT_WAY_OFF_LINE = 5;
    public static Map<Integer, String> map = new HashMap<Integer, String>() {
        private static final long serialVersionUID = 1L;
        {
            put(IN_OUT_WAY_PLATE_NUM, "车牌识别");
            put(IN_OUT_WAY_REMOTE_CONTROL, "遥控器抬杆");
            put(IN_OUT_WAY_QR_CODE, "无牌车扫码");
            put(IN_OUT_WAY_SOFTWARE_MANUAL, "软件人工");
            put(IN_OUT_WAY_OFF_LINE, "断电应急");
        }
    };


    public static String getEnterWayName(Integer code) {
        return map.get(code) + "入场";
    }
    public static String getExitWayName(Integer code) {
        return map.get(code) + "出场";
    }
}
