package com.icetech.common.constants;

import lombok.Getter;


/**
 * @author fangct
 */
public enum CodeConstantsEnum {

    SUCCESS("200","成功"),
    ERROR("500","系统繁忙"),
    ERROR_400("400", "参数格式不正确"),
    ERROR_401("401", "认证失败"),
    ERROR_402("402", "非法参数"),
    ERROR_403("403", "请求方式错误"),
    ERROR_403_11("403.11", "原密码错误"),
    ERROR_404("404", "暂无数据"),
    ERROR_405("405", "请求重复"),
    ERROR_1100("1100", "支付异常,请稍后再试"),
    ERROR_1200("1200","类型不正确"),
    ERROR_2100("2100", "无感支付业务失败"),
    ERROR_2001("2001", "无感支付业务失败"),
    ERROR_2002("2002" ,"用户未授权无感支付"),
    ERROR_2003("2003" ,"退款状态不合法"),
    ERROR_2004("2004" ,"车辆有未离场记录"),
    ERROR_2005("2005" ,"退款金额不合法"),
    ERROR_2006("2006","车场未开通此功能"),
    ERROR_3001("3001" ,"查询费用失败"),
    ERROR_3002("3002" ,"开闸失败"),
    ERROR_510("510" ,"优惠券不在有效期"),
    ERROR_610("610" ,"验证码失效或不正确"),
    ERROR_620("620" ,"验证码发送失败"),
    ERROR_710("710" ,"月卡续租失败"),

    ;
    private @Getter String code;
    private @Getter String desc;
    CodeConstantsEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }
}
