package com.icetech.common.constants;

import java.util.HashMap;
import java.util.Map;


/**
 * @author fangct
 */
public class CodeConstants {
    /**
     * 成功
     */
    public final static String SUCCESS = "200";
    /**
     * 服务器异常
     */
    public final static String ERROR = "500";
    /**
     * 缺失参数或参数格式不正确
     */
    public final static String ERROR_400 = "400";
    /**
     * 签名验证失败
     */
    public final static String ERROR_401= "401";
    /**
     * 请求失败,参数格式正确但业务错误
     */
    public final static String ERROR_402= "402";
    /**
     * 请求方式错误
     */
    public final static String ERROR_403 = "403";
    /**
     * 请求资源不存在
     */
    public final static String ERROR_404 = "404";
    /**
     * 请求重复
     */
    public final static String ERROR_405 = "405";
    /**
     * 下单系统异常
     */
    public final static String ERROR_1100 = "1100";
    /**
     * 类型不正确
     */
    public final static String ERROR_1200 = "1200";
    /**
     * 无感支付业务失败
     */
    public final static String ERROR_2100 = "2100";
    /**
     * 无感支付扣费失败
     */
    public final static String ERROR_2001 = "2001";
    /**
     * 用户未授权无感支付
     */
    public final static String ERROR_2002 = "2002";
    /**
     * 退款状态不合法
     */
    public final static String ERROR_2003 = "2003";
    /**
     * 车辆有未离场记录
     */
    public final static String ERROR_2004 = "2004";
    /**
     * 退款金额不合法
     */
    public final static String ERROR_2005 = "2005";
    /**
     * 车场未开通此功能
     */
    public final static String ERROR_2006 = "2006";
    /**
     * 查询费用失败
     */
    public final static String ERROR_3001 = "3001";
    /**
     * 开闸失败
     */
    public final static String ERROR_3002 = "3002";
    /**
     * 相机未连接
     */
    public final static String ERROR_3003 = "3003";

    /**
     * 前端相机响应超时
     */
    public final static String ERROR_3005 = "3005";
    /**
     * 车辆已经离场
     */
    public final static String ERROR_3004 = "3004";
    /**
     * 离场信息和通道当前车辆不是同一订单
     */
    public final static String ERROR_3006 = "3006";
    /**
     * 无入场记录
     */
    public final static String ERROR_3007 = "3007";
    /**
     * 当前通道没有车辆（这种情况有软件刚启动，缓存没数据的情况）
     */
    public final static String ERROR_3008 = "3008";
    /**
     * 车场没有配置计费规则
     */
    public final static String ERROR_3009 = "3009";
    /**
     * 车辆已支付
     */
    public final static String ERROR_3010 = "3010";
    /**
     * 平台暂不处理
     */
    public final static String ERROR_406 = "406";
    /**
     * 平台延迟处理
     */
    public final static String ERROR_407 = "407";
    /**
     * 外部原因
     */
    public final static String ERROR_408 = "408";
    /**
     * 降级返回
     */
    public final static String ERROR_429 = "429";
    /**
     * 未关联通道信息
     */
    public final static String ERROR_44001 = "44001";
    /**
     * 设备SN不存在
     */
    public final static String ERROR_12001 = "12001";
    /**
     * 等待回调通知
     */
    public final static String ERROR_12002 = "12002";

    public static Map<String, String> map = new HashMap<String, String>() {
        private static final long serialVersionUID = 1L;
        {
            put(SUCCESS, "成功");
            put(ERROR, "系统繁忙");
            put(ERROR_400, "参数格式不正确");
            put(ERROR_401, "认证失败");
            put(ERROR_402, "非法参数");
            put(ERROR_403, "请求方式错误");
            put(ERROR_405, "请求重复");
            put(ERROR_404, "暂无数据");
            put(ERROR_1100, "支付异常,请稍后再试");
            put(ERROR_1200, "类型不正确");
            put(ERROR_2100, "无感支付业务失败");
            put(ERROR_2001, "无感支付扣费失败");
            put(ERROR_2002 ,"用户未授权无感支付");
            put(ERROR_2003 ,"退款状态不合法");
            put(ERROR_2004 ,"车辆有未离场记录");
            put(ERROR_2005 ,"退款金额不合法");
            put(ERROR_2006,"车场未开通此功能");
            put(ERROR_3001 ,"查询费用失败");
            put(ERROR_3002 ,"开闸失败");
            put(ERROR_3003 ,"相机未连接");
            put(ERROR_3004 ,"车辆已经离场");
            put(ERROR_3005 ,"相机响应超时");
            put(ERROR_3006,"离场信息和通道当前车辆不是同一订单");
            put(ERROR_3007,"无入场记录");
            put(ERROR_3008,"当前通道没有车辆");
            put(ERROR_3009,"车场没有配置计费规则");
            put(ERROR_3010,"车辆已支付");
            put(ERROR_406 ,"暂不处理");
            put(ERROR_407 ,"延迟处理");
            put(ERROR_408 ,"外部原因");
            put(ERROR_429 ,"降级返回");
            put(ERROR_44001 ,"未关联通道信息");
            put(ERROR_12001 ,"设备SN不存在");
            put(ERROR_12002 ,"等待回调通知");
        }
    };


    public static String getName(String code) {
        return map.get(code);
    }

    public static String getCode(String name) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (name.equals(entry.getValue())) {
                return entry.getKey();
            }
        }
        return "";
    }

}
