package com.icetech.base.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 用户与车场关联表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-06-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IceSaasUserPark implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 用户id
     */
    private Integer userId;

    /**
     * 车场id
     */
    private Integer parkId;

    /**
     * 所属机构
     */
    private Integer institutionId;

    /**
     * 类型1管理机构2管理车场
     */
    private Integer type;


}
