/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.address;

import cn.hutool.json.JSONUtil;
import com.icetech.address.CarCity;
import com.icetech.address.District;
import com.icetech.address.Strings;
import com.icetech.address.ToJson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class AreacodeFinder {
    private static AreacodeFinder areacodeFinder;
    private List<District> districtList = new ArrayList<District>();
    private List<CarCity> carCityList = null;

    private AreacodeFinder() {
        this.init();
    }

    public AreacodeFinder(String p) {
        this.carCityList = new ArrayList<CarCity>();
        this.init2(p);
    }

    public static AreacodeFinder newInstance() {
        if (areacodeFinder == null) {
            areacodeFinder = new AreacodeFinder();
        }
        return areacodeFinder;
    }

    public static AreacodeFinder newInstance(String p) {
        if (areacodeFinder == null) {
            areacodeFinder = new AreacodeFinder(p);
        }
        return areacodeFinder;
    }

    private void initsheng(List<String> list) {
        for (String shengList : list) {
            String[] sl = shengList.split(",");
            District admin = new District(sl[0], sl[1], sl[2]);
            this.districtList.add(admin);
        }
    }

    private void initshi(List<String> list) {
        for (String shiList : list) {
            String[] shil = shiList.split(",");
            District admin = new District(shil[0], shil[1], shil[2]);
            for (int i = 0; i < this.districtList.size(); ++i) {
                District sh = this.districtList.get(i);
                if (!Strings.startWith(admin.code, sh.code)) continue;
                admin.top = sh;
                sh.districtList.add(admin);
            }
        }
    }

    private void initquxian(List<String> list) {
        for (String quList : list) {
            String[] ql = quList.split(",");
            District admin = new District(ql[0], ql[1], ql[2]);
            for (int i = 0; i < this.districtList.size(); ++i) {
                District sh = this.districtList.get(i);
                if (!Strings.startWith(admin.code, sh.code)) continue;
                for (int j = 0; j < sh.districtList.size(); ++j) {
                    District shi = sh.districtList.get(j);
                    if (!Strings.startWith(admin.code, shi.code)) continue;
                    admin.top = shi;
                    shi.districtList.add(admin);
                }
            }
        }
    }

    private void initjiedao(List<String> list) {
        for (String jieList : list) {
            String[] jl = jieList.split(",");
            District admin = new District(jl[0], jl[1], jl[2]);
            for (int i = 0; i < this.districtList.size(); ++i) {
                District sh = this.districtList.get(i);
                if (!Strings.startWith(admin.code, sh.code)) continue;
                for (int j = 0; j < sh.districtList.size(); ++j) {
                    District shi = sh.districtList.get(j);
                    if (!Strings.startWith(admin.code, shi.code)) continue;
                    for (int k = 0; k < shi.districtList.size(); ++k) {
                        District xian = shi.districtList.get(k);
                        if (!Strings.startWith(admin.code, xian.code)) continue;
                        admin.top = xian;
                        xian.districtList.add(admin);
                    }
                }
            }
        }
    }

    private void initcun(List<String> list) {
        for (String cunList : list) {
            String[] jl = cunList.split(",");
            District admin = new District(jl[0], jl[1], jl[2], null);
            for (int i = 0; i < this.districtList.size(); ++i) {
                District sh = this.districtList.get(i);
                if (!Strings.startWith(admin.code, sh.code)) continue;
                for (int j = 0; j < sh.districtList.size(); ++j) {
                    District shi = sh.districtList.get(j);
                    if (!Strings.startWith(admin.code, shi.code)) continue;
                    for (int k = 0; k < shi.districtList.size(); ++k) {
                        District xian = shi.districtList.get(k);
                        if (!Strings.startWith(admin.code, xian.code)) continue;
                        for (int l = 0; l < xian.districtList.size(); ++l) {
                            District jiedao = xian.districtList.get(l);
                            if (!Strings.startWith(admin.code, jiedao.code)) continue;
                            admin.top = jiedao;
                            jiedao.districtList.add(admin);
                        }
                    }
                }
            }
        }
    }

    private String readFiles2Str(String str) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader buff = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(str)));
        String line = buff.readLine();
        while (line != null) {
            sb.append(line);
            line = buff.readLine();
        }
        return sb.toString();
    }

    private List<String> readFiles(String str) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader buff = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(str)));
        String line = buff.readLine();
        while (line != null) {
            list.add(line);
            line = buff.readLine();
        }
        return list;
    }

    private void init2(String p) {
        try {
            List<String> listSheng = Files.readAllLines(Paths.get(p + "provinces.csv", new String[0]));
            List<String> listShi = Files.readAllLines(Paths.get(p + "cities.csv", new String[0]));
            List<String> listQuxian = Files.readAllLines(Paths.get(p + "areas.csv", new String[0]));
            List<String> carCity = this.readFiles("data/carCity.json");
            this.initsheng(listSheng);
            this.initshi(listShi);
            this.initquxian(listQuxian);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void init() {
        try {
            List<String> listSheng = this.readFiles("data/provinces.csv");
            List<String> listShi = this.readFiles("data/cities.csv");
            List<String> listQuxian = this.readFiles("data/areas.csv");
            String carCity = this.readFiles2Str("data/car_city.json");
            this.initsheng(listSheng);
            this.initshi(listShi);
            this.initquxian(listQuxian);
            this.initCarCity(carCity);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initCarCity(String carCitystr) {
        this.carCityList = JSONUtil.toList((String)carCitystr, CarCity.class);
    }

    public String getJSON(String areaName) {
        District a = null;
        a = areaName.equals("\u4e2d\u56fd") ? new District("000000000000", "\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd", "\u4e2d\u56fd", this.districtList) : new District("", "", "", null);
        if (Strings.isNum(areaName)) {
            areaName = this.searchByCode(areaName);
        }
        District b = this.findNode(a, this.districtList, areaName, 1);
        return ToJson.tojson(b);
    }

    public List<District> getDistrictList() {
        return this.districtList;
    }

    public CarCity getCityByPlate(String plate) {
        Optional<CarCity> first = this.carCityList.stream().filter(carCity -> carCity.getCode().equals(plate)).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        return null;
    }

    public String searchByAddress(String str) {
        District a = new District("000000000000", "\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd", "\u4e2d\u56fd", null);
        District b = this.findNode(a, this.districtList, str, 1);
        String string = b.code;
        int size = 12 - string.length();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                string = string + "0";
            }
        }
        return string;
    }

    public String searchByCode(String str) {
        return this.findCode(this.districtList, str, "");
    }

    private String findCode(List<District> nodelist, String str, String name) {
        int size = nodelist.size();
        for (int i = 0; i < size; ++i) {
            District admin = nodelist.get(i);
            if (!Strings.startWith(str, admin.code)) continue;
            if (admin.districtList != null) {
                return this.findCode(admin.districtList, str, name + admin.name);
            }
            return name + admin.name;
        }
        return name;
    }

    private District findNode(District curr, List<District> nodelist, String address, Integer grade) {
        boolean iszhaodao = false;
        District currentNode = null;
        int nodesize = nodelist.size();
        for (int i = 0; i < nodesize; ++i) {
            District ad = nodelist.get(i);
            if (!Strings.contains(address, ad.omitName)) continue;
            iszhaodao = true;
            currentNode = ad;
            break;
        }
        if (iszhaodao) {
            if (currentNode.districtList != null) {
                return this.findNode(currentNode, currentNode.districtList, this.replace(address.replace(currentNode.omitName, ""), grade), grade + 1);
            }
            return currentNode;
        }
        return this.findNodeJump(curr, nodelist, address, grade + 2);
    }

    private District findNodeJump(District cur, List<District> nodelist, String address, Integer grade) {
        District admin;
        int j;
        int size;
        District ad;
        int i;
        int nodesize = nodelist.size();
        for (i = 0; i < nodesize; ++i) {
            ad = nodelist.get(i);
            if (ad.districtList == null) continue;
            size = ad.districtList.size();
            for (j = 0; j < size; ++j) {
                admin = ad.districtList.get(j);
                if (!Strings.contains(address, admin.omitName)) continue;
                if (admin.districtList != null) {
                    return this.findNode(admin, admin.districtList, this.replace(address.replace(admin.omitName, ""), grade), grade + 2);
                }
                return admin;
            }
        }
        nodesize = nodelist.size();
        for (i = 0; i < nodesize; ++i) {
            ad = nodelist.get(i);
            if (ad.districtList == null) continue;
            size = ad.districtList.size();
            for (j = 0; j < size; ++j) {
                admin = ad.districtList.get(j);
                if (admin.districtList == null) continue;
                int si = admin.districtList.size();
                for (int k = 0; k < si; ++k) {
                    District district = admin.districtList.get(k);
                    if (!Strings.contains(address, district.omitName)) continue;
                    if (district.districtList != null) {
                        return this.findNode(district, district.districtList, this.replace(address.replace(district.omitName, ""), grade), grade + 3);
                    }
                    return district;
                }
            }
        }
        return cur;
    }

    private String replace(String str, Integer grade) {
        switch (grade) {
            case 1: {
                return str.replaceFirst("\u7701", "").replaceFirst("\u5e02", "");
            }
            case 2: {
                return str.replaceFirst("\u5e02", "").replaceFirst("\u76df", "").replaceFirst("\u81ea\u6cbb\u5dde", "");
            }
            case 3: {
                return str.replaceFirst("\u533a", "").replaceFirst("\u81ea\u6cbb\u53bf", "").replaceFirst("\u53bf", "");
            }
            case 4: {
                return str.replaceFirst("\u8857\u9053", "").replaceFirst("\u9547", "").replaceFirst("\u4e61", "");
            }
        }
        return str;
    }
}

