package com.icetech.p2p.param;

import com.icetech.p2p.enums.SourceEnums;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * Description IceFixedLicenseParam
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/4/6 13:59
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class IceFixedLicenseParam implements Serializable {

    /**
     * 设备SN号
     */
    @NotNull(message = "sn not null")
    private String sn;

    /**
     * @see SourceEnums
     */
    @NotNull(message = "source not null")
    private Integer source;

    /**
     * 过期时间
     */
    @NotNull(message = "expireTime not null")
    private Date expireTime;
}
