package com.icetech.p2p.enums;

/**
 * Description SourceEnums
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/4/6 11:05 上午
 */
public enum SourceEnums {

    /**
     *设备运维平台
     */
    DEVICE(1, "设备运维平台"),

    /**
     *APP付费
     */
    APP_PAID(2, "APP付费"),
    
    /**
     * 购机赠送
     */
    BUYERS_AWAY(3, "购机赠送"),
    ;

    private Integer code;
    private String msg;

    SourceEnums(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static SourceEnums getTypeEnumByCode(Integer code) {
        for (SourceEnums skipTypeEnum : SourceEnums.values()) {
            if (skipTypeEnum.getCode().equals(code)) {
                return skipTypeEnum;
            }
        }
        return null;
    }
}
