package com.icetech.p2p.api;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.p2p.param.IceFixedLicenseParam;
import com.icetech.p2p.vo.IceFixedLicenseVo;

/**
 * Description IceFixedLicenseApi
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/4/6 13:57
 */
public interface IceFixedLicenseApi {
    
    /**
     * Description: 查询sn 的固定license
     * Version1.0 2022-04-06 by wgy 创建
     * 
     * @param sn    sn 号
     * @return com.icetech.common.domain.response.ObjectResponse<com.icetech.p2p.domain.vo.IceFixedLicenseVo>       
     */
    ObjectResponse<IceFixedLicenseVo> getFixedLicenseBySn(String sn);

    /**
     * Description: 增加固定 license
     * Version1.0 2022-04-06 by wgy 创建
     * 
     * @param iceFixedLicenseParam  参数
     * @return com.icetech.common.domain.response.ObjectResponse<java.lang.Void>       
     */
    ObjectResponse<Boolean> addFixedLicense(IceFixedLicenseParam iceFixedLicenseParam);

    /**
     * Description: 移除sn 固定license
     * Version1.0 2022-04-06 by wgy 创建
     * 
     * @param sn    sn 号
     * @return com.icetech.common.domain.response.ObjectResponse<java.lang.Void>       
     */
    ObjectResponse<Boolean> removeFixedLicense(String sn);
}
