package com.icetech.p2p.api;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.p2p.vo.LicenseAuthVO;

/**
 * Description DeviceLicenseApi
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/4/6 18:33
 */
public interface DeviceLicenseApi {
    
    /**
     * Description: 获取视频地址（无限制）
     * Version1.0 2022-04-07 by wgy 创建
     * 
     * @param clientAgent   客户端来源, 1-html,2-hls
     * @param sn            设备sn
     * @return com.icetech.common.domain.response.ObjectResponse<com.icetech.p2p.vo.LicenseAuthVO>       
     */
    ObjectResponse<LicenseAuthVO> videoUrl(Integer clientAgent, String sn);
    
    /**
     * Description: license 释放（停止播放）
     * Version1.0 2022-04-07 by wgy 创建
     * 
     * @param sn        sn号
     * @return com.icetech.common.domain.response.ObjectResponse<java.lang.Void>
     */
    ObjectResponse<Void> licenseRelease(String sn);
}
