/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.city.road.utils;

import cn.hutool.core.lang.Snowflake;
import com.icetech.city.road.utils.NumberUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;

public class Slf4jUtils {
    public static final String KEY_TRACE_ID = "TraceId";
    private static final Snowflake SNOWFLAKE;

    public static String putTraceId() {
        return Slf4jUtils.putTraceId(SNOWFLAKE.nextIdStr());
    }

    public static String putTraceId(String traceId) {
        MDC.put((String)KEY_TRACE_ID, (String)traceId);
        return traceId;
    }

    public static String initTraceId(String traceId) {
        if (StringUtils.isBlank((CharSequence)traceId)) {
            return Slf4jUtils.putTraceId();
        }
        return Slf4jUtils.putTraceId(traceId);
    }

    public static String putTraceIdIfAbsent() {
        String traceId = Slf4jUtils.getTraceId();
        if (StringUtils.isBlank((CharSequence)traceId)) {
            return Slf4jUtils.putTraceId();
        }
        return traceId;
    }

    public static String getTraceId() {
        return MDC.get((String)KEY_TRACE_ID);
    }

    public static void removeTraceId() {
        MDC.remove((String)KEY_TRACE_ID);
    }

    static {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String name = runtime.getName();
        int pid = NumberUtils.toInt((String)StringUtils.substring((String)name, (int)0, (int)name.indexOf("@")));
        SNOWFLAKE = new Snowflake((long)(pid % 31), 0L);
    }
}

