package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 停车区表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_region")
public class Region implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 自增主健id
     */
    @TableId(value = "id", type = IdType.AUTO)
    protected Integer id;
    /**
     * 停车区编号（唯一）
     */
    @TableField("region_code")
    protected String regionCode;
    /**
     * 停车区名称
     */
    @TableField("region_name")
    protected String regionName;
    /**
     * 所属省份
     */
    @TableField("province_id")
    protected Integer provinceId;
    /**
     * 所属城市
     */
    @TableField("city_area_id")
    protected Integer cityAreaId;
    /**
     * 所属区域
     */
    @TableField("district_id")
    protected Integer districtId;
    /**
     * 所属机构ID
     */
    @TableField("institution_id")
    protected Integer institutionId;
    /**
     * 停车区业态（1：开发式平行，2：开放式垂直，默认2）
     */
    @TableField("region_shape")
    protected Integer regionShape;
    /**
     * 停车区地址
     */
    @TableField("region_address")
    protected String regionAddress;
    /**
     * 联系人
     */
    @TableField("contacts")
    protected String contacts;
    /**
     * 联系电话
     */
    @TableField("phone")
    protected String phone;
    /**
     * 添加时间
     */
    @TableField("create_time")
    protected Date createTime;
    /**
     * 添加人
     */
    @TableField("adder")
    protected String adder;
    /**
     * 更新时间
     */
    @TableField("update_time")
    protected Date updateTime;
    /**
     * 更新人
     */
    @TableField("update_user")
    protected String updateUser;
    /**
     * 描述信息
     */
    @TableField("remark")
    protected String remark;
}
