package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.utils.DateUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 订单票据信息表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_pos_ticket")
public class PosTicket implements Serializable {
    /** ID */
    @TableId(value = "id", type = IdType.AUTO)
    protected Long id;
    /** 车场ID */
    protected Integer parkId;
    /** 终端号 */
    protected String deviceSn;
    /** 订单号 */
    protected String orderNum;
    /** 员工ID */
    protected Long employeeId;
    /** 员工用户名 */
    protected String empUsername;
    /** 泊位编号 */
    protected Integer berthId;
    /** 泊位编号 */
    protected String berthCode;
    /** 车牌号 */
    protected String plateNum;
    protected Integer orderType;
    protected LocalDateTime enterTime;
    /** 停车时长(秒) */
    protected Integer parkDuration;
    protected BigDecimal totalAmount;
    protected BigDecimal discountAmount;
    protected BigDecimal paidAmount;
    protected BigDecimal unpaidAmount;
    /** 打印时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime printTime;
    /** 备注 */
    protected String remark;
    /** 创建时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime createTime;
}
