package com.icetech.city.road.domain.table;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 按次收费方式
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_once_config")
public class OnceConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 计费规则编号 时间+随机数小于16位
     */
    private String billtypecode;

    /**
     * 收费类型 1：通用自然天收费 2：白天夜间收费
     */
    private Integer isnaturaldayfee;

    /**
     * isnaturaldayfee是1时：是工作日或非工作日计费标识 1：工作日 2非工作日；isnaturaldayfee是2时：是白天或夜间计费标识 1：白天 2夜间
     */
    private Integer dayornightfeemark;

    /**
     * 是否开启每次收费开关 1是 2否  默认是
     */
    private Integer isopenoncecharge;

    /**
     * 每次收费金额 元
     */
    private BigDecimal oncechargefee;

    /**
     * 大型车每次收费金额 元
     */
    private BigDecimal oncechargefeeBig;

    /**
     * 是否开启按分钟收费开关 1是 2否 默认否
     */
    private Integer isopenother2;

    /**
     * 多少分钟范围   分钟
     */
    private Integer timeFrame;

    /**
     * 多少分钟范围计费多少钱 元
     */
    private BigDecimal timeFrameOncefee;

    /**
     * 大型车多少分钟范围计费多少钱 元
     */
    private BigDecimal timeFrameOncefeeBig;

    /**
     * 超时多少分钟范围每次收费多少钱 元
     */
    private BigDecimal otherTimeframeOncefee;

    /**
     * 大型车超时多少分钟范围每次收费多少钱 元
     */
    private BigDecimal otherTimeframeOncefeeBig;

    /**
     * 是否有附加选择项 1是 2否 默认为2
     */
    private Integer isattachoption;

    /**
     * 附加选择超过分钟数  分钟
     */
    private Integer overTime;

    /**
     * 加收过夜费 元
     */
    private BigDecimal addOvernightFee;

    /**
     * 大型车加收过夜费 元
     */
    private BigDecimal addOvernightFeeBig;

    /**
     * 添加时间
     */
    private Date createTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 描述信息
     */
    private String remark;


}
