package com.icetech.city.road.domain.table;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
@TableName("`ice_mp_user_prompt`")
public class MpUserPrompt {
    /** ID */
    @TableId(value = "`id`", type = IdType.AUTO)
    protected Long id;
    /** 提醒类型(1-订单申诉;2-车牌申诉;3-反馈建议;) */
    @TableField("`type`")
    protected Integer type;
    /** 提醒内容 */
    @TableField("`content`")
    protected String content;
    /** 用户ID */
    @TableField("`user_id`")
    protected Long userId;
    /** 关联ID */
    @TableField("`relation_id`")
    protected Long relationId;
    /** 关联数据 */
    @TableField("`relation_date`")
    protected String relationDate;
    /** 创建时间 */
    @TableField("`create_time`")
    protected Date createTime;
    /** 已读标识(0-未读;1-已读) */
    @TableField("`read_flag`")
    protected Integer readFlag;
    /** 已读时间 */
    @TableField("`read_time`")
    protected Date readTime;
}
