package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 月卡购买记录表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_month_pay_record")
public class MonthPayRecord implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 月卡ID
     */
    private Integer monthId;

    /**
     * 月卡套餐ID
     */
    private Integer productId;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 支付渠道 1:云平台办理;2:小程序
     */
    private Integer payChannel;

    /**
     * 支付时间
     */
    private Long payTime;

    /**
     * 支付金额
     */
    private BigDecimal payAmount;

    /**
     * 使用开始时间(年月日)
     */
    private Date useBeginDate;

    /**
     * 使用结束时间(年月日)
     */
    private Date useEndDate;

    /**
     * 购买年月
     */
    private String payYearMonth;

    /**
     * 交易流水号
     */
    private String tradeNo;

    /**
     * 月卡操作记录id
     */
    private Integer monthRecordId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

}
