package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableName;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 地磁设备表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_dev_magnetism_record")
public class DevMagnetismRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 自增主键id
     */
    private Integer id;

    /**
     * 设备序列号（上报状态时校验使用）
     */
    private String devSerialnumber;
    /**
     * 车位状态序号
     */
    private Integer sequence;



    /**
     * 设备id
     */
    private Integer devId;
    /**
     * 设备标识
     */
    private String devSign;

    /**
     * 泊位id
     */
    private Integer berthId;

    /**
     * 上报状态（1：有车，2：无车）
     */
    private Integer reportStatus;

    /**
     * 上报时间
     */
    private Long reportTime;

    /**
     * 终端设备接收信号得强度（例如：16）
     */
    private String signalValue;
    /**
     * 电量
     */
    private String voltage;



    /**
     * 添加时间
     */
    private LocalDateTime createTime;

    /**
     * 添加人
     */
    private String adder;


}
