package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 员工考勤表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-08-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_daily_time")
public class DailyTime implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 用户id
     */
    private Integer userId;

    /**
     * 签到时间
     */
    private Long signinTime;

    /**
     * 签退时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Long signoutTime;

    /**
     * 签到地点
     */
    private String signinAddress;

    /**
     * 签退地点
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private String signoutAddress;

    /**
     * 签到坐标
     */
    private String signinCoordinate;

    /**
     * 签退坐标
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private String signoutCoordinate;

    /**
     * 用户类型，1手持机管理员
     */
    private Integer userType;

    /**
     * 用户状态0=离线1=在线
     */
    private Boolean loginStatus;

    /**
     * 设备id
     */
    private Integer devId;

    /**
     * 添加时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;


}
