package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName("ice_charge_once")
public class ChargeOnce implements Serializable {
    /** id */
    @TableId(type = IdType.AUTO)
    protected Integer id;
    /** 计费规则编号 时间+随机数小于16位 */
    protected String billtypecode;
    /** 收费类型 1：通用自然天收费 2：白天夜间收费 */
    protected Integer isnaturaldayfee;
    /** {@link #isnaturaldayfee}是1时：是工作日或非工作日计费标识 1：工作日 2非工作日；
     * {@link #isnaturaldayfee}是2时：是白天或夜间计费标识 1：白天 2夜间 */
    protected Integer dayornightfeemark;
    /** 是否开启每次收费开关 1是 2否  默认是 */
    protected Integer isopenoncecharge;
    /** 每次收费金额 元 */
    protected BigDecimal oncechargefee;
    /** 是否开启按分钟收费开关 1是 2否 默认否 */
    protected Integer isopenother2;
    /** 多少分钟范围   分钟 */
    protected Integer timeFrame;
    /** 多少分钟范围计费多少钱 元 */
    protected BigDecimal timeFrameOncefee;
    /** 超时多少分钟范围每次收费多少钱 元 */
    protected BigDecimal otherTimeframeOncefee;
    /** 是否有附加选择项 1是 2否 默认为2 */
    protected Integer isattachoption;
    /** 附加选择超过分钟数  分钟 */
    protected Integer overTime;
    /** 加收过夜费 元 */
    protected BigDecimal addOvernightFee;
    /** 大型车每次收费金额 元 */
    protected BigDecimal oncechargefeeBig;
    /** 大型车多少分钟范围计费多少钱 元 */
    protected BigDecimal timeFrameOncefeeBig;
    /** 大型车超时多少分钟范围每次收费多少钱 元 */
    protected BigDecimal otherTimeframeOncefeeBig;
    /** 大型车加收过夜费 元 */
    protected BigDecimal addOvernightFeeBig;
}
