package com.icetech.city.road.domain.constant;

import java.time.Duration;

public interface RedisConstant {
    String SERVER_EXPIRE= "server:token";
    String KEY_PREFIX_VENDOR_PARK = "city:park:vendor:";

    String KEY_PREFIX_THIRD_PUSH_CONFIG = "city:third:push:config:";

    String NONE_DATA = "$NONE$";
    Duration DURATION_24HOUR = Duration.ofHours(24);

    /** 高位心跳 */
    String CAMERA_HEARTBEAT = "city:camera:heartbeat:";
    /** 低位视频桩心跳 */
    String VIDEO_PILE_HEARTBEAT = "city:video_pile:heartbeat:";
    /** 地磁心跳标识 */
    String DC_HEARTBEAT = "city:dc:heartbeat:";
    String INSPECTION_HEARTBEAT = "city:inspection:heartbeat:";
    String POS_HEARTBEAT = "city:pos:heartbeat:";
    /**
     * 地磁上次泊位状态缓存
     */
    String DC_LAST_STATUS = "city:dc:status:";
    String DC_LAST_REPORT = "city:dc:report:";

    /**
     * pos机登录设备前缀
     */
    String POS_LOGIN_SECRET_USER = "city:pos:login:user:";
    String POS_LOGIN_SECRET_TOKEN = "city:pos:login:token:";
    String POS_SN_SECRET_USER= "city:pos:secret:sn:";
    String POS_USER_SECRET_SN= "city:pos:secret:user:";
    String POS_SN_SECRET_TOKEN= "city:pos:secret:sn:";


    /**
     * h5登录
     */
    String H5_ACCESS_TOKEN_KEY= "city:h5:token:";

    /**
     * saas平台登录前缀
     */
    String SAAS_LOGIN = "city:userinfo:user_";
    /**
     * 新吴平台token
     */
    String XINWU_TOKEN = "xinwu:token";

    /**
     * 费用缓存
     */
    String FEE_CATCH_ORDER = "FEE:CATCH:ORDER";

    /**
     * 智交上报TOKEN
     */
    String ZHIJIAO_REPORT_TOKEN = "zj:report:token:";

    String REDIS_KEY_POS_PAY_TRADE = "city:pos:pay:trade:";
    String REDIS_KEY_PAY_DISC = "city:pay:disc:";

    /**
     * pos机缓存key
     */
    String REDIS_KEY_POS_PAY_URL = "city:pos:pay:url:";
    String REDIS_KEY_POS_PAY_RDT = "city:pos:pay:rdt:";

    /**
     * 诺诺开票缓存令牌
     */
    String NUO_NUO_INVOICE = "nuo:invoice:token";
}
