package com.icetech.city.road.domain.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * 车辆进出场方式
 * @author wangzhiwei
 */
public interface EnexWayConstant {
    /** 高位视频 */
    Integer HIGH = 1;
    /** 地磁 */
    Integer DC = 2;
    /** POS机 */
    Integer POS = 3;
    /** 人工 */
    Integer MO = 4;
    /** 巡检车 */
    Integer INSPECTION = 5;
    /** 自动离场 */
    Integer AUTO = 6;
    /** 低位视频桩 */
    Integer VIDEO_PILE = 7;
    /** 车辆自助离场 */
    Integer VEHICLE = 8;

    Map<Integer, String> map = new HashMap<Integer, String>() {{
        put(HIGH, "高位视频");
        put(DC, "地磁");
        put(POS, "POS机");
        put(MO, "人工");
        put(INSPECTION, "巡检车");
        put(AUTO, "自动离场");
    }};
    static String desc(Integer enexWay){
        return map.get(enexWay);
    }

}
