package com.icetech.city.road.component.jackson;

import java.util.HashMap;
import java.util.Map;

public enum TemporalFormatType {
    PATTERN,
    EPOCH_MILLIS,
    EPOCH_SECS,
    EPOCH_DAY,
    //        DAY_MILLIS,
    DAY_SECS,
    ;

    public static TemporalFormatType resolveType(String value) {
        if (value == null) return null;
        TemporalFormatType type = MAP.get(value);
        if (type == PATTERN) return null;
        return type;
    }

    private static final Map<String, TemporalFormatType> MAP;

    static {
        MAP = new HashMap<>();
        for (TemporalFormatType value : TemporalFormatType.values()) {
            MAP.put(value.name(), value);
        }
    }
}
