package com.icetech.city.road.app.undefined.dto;


import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 支付子项
 * @author wangzhiwei
 */
@Data
public class PayToItem implements Serializable {
    /**
     * 订单号
     */
    private String orderNum;
    /**
     * 交易流水号
     */
    private String tradeNo;
    /**
     * 实际支付金额
     */
    private BigDecimal paidPrice;
    /**
     * 实际优惠金额
     */
    private BigDecimal discountPrice;

    /**
     * 应收金额
     */
    private BigDecimal totalPrice;

    public void setDiscountPrice(BigDecimal discountPrice){
        discountPrice = discountPrice.compareTo(BigDecimal.ZERO)==-1?BigDecimal.ZERO:discountPrice;
        this.discountPrice = discountPrice;
    }

    public void setPaidPrice(BigDecimal paidPrice){
        paidPrice = paidPrice.compareTo(BigDecimal.ZERO)==-1?BigDecimal.ZERO:paidPrice;
        this.paidPrice = paidPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice){
        totalPrice = totalPrice.compareTo(BigDecimal.ZERO)==-1?BigDecimal.ZERO:totalPrice;
        this.totalPrice = totalPrice;
    }
}
