package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.icetech.city.road.utils.DateUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Date;
import java.util.Objects;

/**
 * <p>
 * VIP车辆信息表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-08-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_vip_info")
public class VipInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * VIP车辆类型id
     */
    private Integer typeId;

    /**
     * 车场id
     */
    private Integer parkId;

    /**
     * 姓名
     */
    private String owner;

    /**
     * 电话
     */
    private String phone;

    /**
     * 有效开始日期
     */
    private Date startTime;

    /**
     * 有效结束日期
     */
    private Date endTime;

    /**
     * 操作人
     */
    private String operAccount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private Date updateTime;


    public Date getStartTime() {
        if (Objects.isNull(startTime)){
            return null;
        }
        return new Date(DateUtils.toEpochMilli(LocalDate.now().atStartOfDay()));
    }

    public Date getEndTime() {
        if (Objects.isNull(endTime)) {
            return null;
        }
        return new Date(DateUtils.toEpochMilli(LocalDate.now().atTime(LocalTime.ofSecondOfDay(24 * 60 * 60 - 1))));
    }
}
