package com.icetech.city.road.domain.table;

import java.time.LocalDateTime;
import java.time.LocalTime;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 上海道路平台费率信息
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_shanghai_rate")
public class ShanghaiRate {
    /**
     * ID
     */
    @TableId(value = "id", type = IdType.INPUT)
    protected Long id;
    /**
     * 费率编号
     */
    @TableField("rate_num")
    protected String rateNum;
    /**
     * 费率描述
     */
    @TableField("rate_desc")
    protected String rateDesc;
    /**
     * 车辆类型(0-大小型车;1-小型车;2-大型车)
     */
    @TableField("vehicle_type")
    protected Integer vehicleType;
    /**
     * 收费日期类型(1-平日;2-周末;3-节假日)
     */
    @TableField("date_type")
    protected Integer dateType;
    /**
     * 收费类型(1-计时;2-计次)
     */
    @TableField("charge_type")
    protected Integer chargeType;
    /**
     * 收费开始时间
     */
    @TableField("charge_begin")
    protected LocalTime chargeBegin;
    /**
     * 收费结束时间
     */
    @TableField("charge_end")
    protected LocalTime chargeEnd;
    /**
     * 首时段费率金额(分/小时)
     */
    @TableField("first_period_rate")
    protected Integer firstPeriodRate;
    /**
     * 首时段时长(分钟)
     */
    @TableField("first_period_len")
    protected Integer firstPeriodLen;
    /**
     * 后时段费率(分/小时)
     */
    @TableField("next_period_rate")
    protected Integer nextPeriodRate;
    /**
     * 后时段时长(分钟)
     */
    @TableField("next_period_len")
    protected Integer nextPeriodLen;
    /**
     * 记录更新时间
     */
    @TableField("update_time")
    protected LocalDateTime updateTime;
    /**
     * 记录获取时间
     */
    @TableField("fetch_time")
    protected LocalDateTime fetchTime;
}
