package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 菜单表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_saas_node")
public class SaasNode implements Serializable {
    private static final long serialVersionUID = 1L;
    /** ID */
    protected Integer id;
    /** 菜单名 */
    protected String title;
    /** action/url */
    protected String action;
    /** 状态（0：正常，1：删除，默认0） */
    protected Integer status;
    /** 备注 */
    protected String remark;
    /** 排序 */
    protected Integer sort;
    /** 父级ID */
    protected Integer pid;
    /** 菜单等级 1,2,3 */
    protected Integer nlevel;
    /** 所属模块id 只有一级菜单才有此值 */
    protected Integer mid;
    /** 是否展示（0：不展示，1：展示，默认0） */
    protected Integer isShow;
    /** 菜单类型 1路内 2场库 */
    protected Integer nodeType;
    /** 添加人 */
    protected String adder;
    /** 添加时间 */
    protected Date addtime;
    /** 最后修改人 */
    protected String updateUser;
    /** 最后修改时间 */
    protected Date updateTime;
}
