package com.icetech.city.road.domain.table;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

/**
 * RabbitMQ消费失败信息表
 */
@Data
@TableName(value = "`ice_rabbit_failed`")
public class RabbitFailed {
    /**
     * 主键自增长id
     */
    @TableId(value = "`id`")
    protected Long id;
    /**
     * 消息ID
     */
    @TableField(value = "`message_id`")
    protected String messageId;
    /**
     * 交换机
     */
    @TableField(value = "`received_exchange`")
    protected String receivedExchange;
    /**
     * 路由键
     */
    @TableField(value = "`received_routing_key`")
    protected String receivedRoutingKey;
    /**
     * 消息内容
     */
    @TableField(value = "`message_payload`")
    protected String messagePayload;
    /**
     * 消费队列
     */
    @TableField(value = "`consumer_queue`")
    protected String consumerQueue;
    /**
     * 失败原因
     */
    @TableField(value = "`failed_reason`")
    protected String failedReason;
    /**
     * 异常信息
     */
    @TableField(value = "`throwable`")
    protected String throwable;
    /**
     * 接收时间
     */
    @TableField(value = "`received_time`")
    protected Date receivedTime;
    /**
     * 备注
     */
    @TableField(value = "`remark`")
    protected String remark;
    /**
     * 创建时间
     */
    @TableField(value = "`create_time`")
    protected Date createTime;
}
