package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * 凭条模板列表
 *
 * @author wgq
 */
@Data
@TableName("ice_receipt")
public class ParkReceiptTemplate {

    /**
     * 自增主健id
     */
    @TableId(value = "id", type = IdType.AUTO)
    protected Integer id;
    /**
     * 模板名称
     */
    private String templateName;
    /**
     * 用户ID
     */
    private Integer userId;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
}
