package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 订单申诉
 */
@Data
@Accessors(chain = true)
@TableName("ice_mp_appeal_order")
public class MpAppealOrder implements Serializable {
    /** ID */
    @TableId(value = "`id`", type = IdType.AUTO)
    protected Long id;
    /** 微信用户ID */
    @TableField("`user_id`")
    protected Long userId;
    /**
     * 订单来源 (1-路内;2-厂库)
     */
    @TableField("`order_source`")
    protected Integer orderSource;
    /** 申诉订单号 */
    @TableField("`order_num`")
    protected String orderNum;
    /** 申诉内容 */
    @TableField("`content`")
    protected String content;
    /** 图片链接 */
    @TableField("`image`")
    protected String image;
    /** 联系方式(QQ/电话/邮箱) */
    @TableField("`contact_way`")
    protected String contactWay;
    /** 申诉状态 */
    @TableField("`appeal_status`")
    protected Integer appealStatus;
    /** 拒绝原因 */
    @TableField("`reject_reason`")
    protected String rejectReason;
    /** 创建时间 */
    @TableField("`create_time`")
    protected Date createTime;
    /** 审核人ID */
    @TableField("`check_user`")
    protected Long checkUser;
    /** 审核时间 */
    @TableField("`check_time`")
    protected Date checkTime;
}
