package com.icetech.city.road.domain.table;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 月卡产品操作记录表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-09-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_month_product_record")
public class MonthProductRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 月卡产品id
     */
    private Integer productId;

    /**
     * 道路id  多个道路用,分割
     */
    private String parkId;

    /**
     * 产品名称
     */
    private String name;

    /**
     * 产品面额（1个月2个月等）
     */
    private Integer duration;

    /**
     * 所售金额
     */
    private BigDecimal paymoney;

    /**
     * 适用时段(描述)全天 00：00：00—23：59：59，时段07：00：00—19：59：59
     */
    private String protime;

    /**
     * 修改前所售状态
     */
    private Integer beforeStatus;

    /**
     * 修改后所售状态
     */
    private Integer afterStatus;

    /**
     * 审核状态（默认0未审核1通过2未通过）
     */
    private Integer checkStatus;

    /**
     * 操作类型（1删除，2审核，3编辑，4新增，5更改所售状态）
     */
    private Integer operType;

    /**
     * 类型是否显示（审核不显示）1显示 0不显示
     */
    private Integer isShow;

    /**
     * 产品创建时间
     */
    private LocalDateTime productCreatetime;

    /**
     * 操作人
     */
    private String operAccount;

    /**
     * 操作时间
     */
    private LocalDateTime operTime;

    /**
     * 套餐每月预售数量
     */
    private Integer presaleQuantity;

    /**
     * 单日所售金额
     */
    private BigDecimal dailyAmount;

    /**
     * 是否支持线上售卖 1支持0不支持
     */
    private Integer supportOnlinepay;

    /**
     * 使用规则
     */
    private String userChareg;


}
