package com.icetech.city.road.domain.table;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalTime;
import java.time.LocalDateTime;
import java.io.Serializable;

import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.utils.DateUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 月卡产品表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-09-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_month_product")
public class MonthProduct implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 产品名称
     */
    private String name;

    /**
     * 产品面额（1个月2个月等）
     */
    private Integer duration;

    /**
     * 适用时段1全天2分时段
     */
    private Integer cardType;

    /**
     * 所售金额
     */
    private BigDecimal paymoney;

    /**
     * 开始日期 产品可用日期
     */
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATE_PATTERN)
    private LocalDate startDate;

    /**
     * 结束日期 产品可用日期
     */
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATE_PATTERN)
    private LocalDate endDate;

    /**
     * 开始时间点 产品可用时间
     */
    @TemporalFormat(pattern = DateUtils.DEFAULT_TIME_PATTERN)
    private LocalTime startTime;

    /**
     * 结束时间点（跨天开始>结束）
     */
    @TemporalFormat(pattern = DateUtils.DEFAULT_TIME_PATTERN)
    private LocalTime endTime;

    /**
     * 审核状态（默认0未审核1通过2未通过）
     */
    private Integer checkStatus;

    /**
     * 购买渠道 0：仅平台可购买 1：平台和公众号均可购买 默认为0
     */
    private Integer buyChannel;

    /**
     * 是否允许续费 0：不允许 1：允许 默认为1
     */
    private Integer isRenewFee;

    /**
     * 是否赠送天数 0：不赠送 1：赠送 默认为0
     */
    private Integer isDiftDay;

    /**
     * 赠送多少天 默认0
     */
    private Integer diftDays;

    /**
     * 所售状态0 未售  1 在售  2 停售 3 过期
     */
    private Integer status;

    /**
     * 审核说明
     */
    private String feedback;
    /**
     * 错时卡公休日节假日是否免费，0否1是
     */
    private Integer isHolidayFree;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 修改人
     */
    private String editer;

    /**
     * 是否删除0：正常 1：删除默认0
     */
    private Integer delflag;

    /**
     * 添加时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;

    /**
     * 套餐每月预售数量
     */
    private Integer presaleQuantity;

    /**
     * 线上可售月卡总量
     */
    private Integer totalOnlineQuantity;

    /**
     * 单日所售金额
     */
    private BigDecimal dailyAmount;

    /**
     * 是否支持线上售卖 1支持0不支持
     */
    private Integer supportOnlinepay;

    /**
     * 使用规则
     */
    private String userChareg;

    /**
     * 购买须知
     */
    private String buyNotice;

    /**
     * 客服电话
     */
    private String customerServicePhone;

    /**
     * 是否免费工作日限号 1是0否
     */
    private Integer workingDayLimit;

    /**
     * 描述标签
     */
    private String tagContent;
}
