package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 发票-发票与交易关联表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_invoice_trade")
public class InvoiceTrade implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 自增主健id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 开票订单号
     */
    private String orderId;

    /**
     * 平台交易流水号
     */
    private String tradeNo;

    /**
     * 来源
     */
    private Integer source;

    /**
     * 机构id
     */
    private Integer institutionId;


}
