package com.icetech.city.road.domain.table;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 审核记录表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-06-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_etc_notify_detail")
public class EtcNotifyDetail implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 道路id
     */
    private Integer parkId;

    /**
     * ETC 扣款的订单编号
     */
    private String orderNum;

    /**
     * 交易金额
     */
    private BigDecimal fee;

    /**
     * 泊位号
     */
    private Integer berthId;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 设备编号
     */
    private String deviceNo;

    /**
     * 扣费结果
     */
    private Integer paystatus;

    /**
     * 交易id
     */
    private String transid;

    /**
     * 交易流水号
     */
    private String detailno;

    /**
     * 卡号
     */
    private String iccode;

    /**
     * 卡号网络
     */
    private String netno;

    /**
     * 车牌颜色
     */
    private Integer plateColor;

    /**
     * 卡片类型
     */
    private String ictype;

    /**
     * 出口类型
     */
    private String exptype;

    /**
     * PSAM 终端号
     */
    private String termcode;

    /**
     * 终端交易号
     */
    private String termseq;

    /**
     * 交易校验码
     */
    private String tac;

    /**
     * PSAM 交易序号
     */
    private String terminalTransNo;

    /**
     * OBU 序列号
     */
    private String obuId;

    /**
     * 车型
     */
    private String vehicleType;

    /**
     * 卡交易序号
     */
    private String transNo;

    /**
     * 卡交易类型
     */
    private String transType;

    /**
     * 卡交易时间
     */
    private String transtime;

    /**
     * 余额
     */
    private BigDecimal balance;

    private Date createTime;

    private String adder;

    private Date updateTime;

    private String updateUser;
    /**
     * 备注信息
     */
    private String remark;

    /**
     * 车牌颜色
     */
    @TableField(exist = false)
    private String plateColorStr;

}
