package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName("ice_empe_score_rule")
public class EmpeScoreRule implements Serializable {
    /** ID */
    @TableId("id")
    protected Long id;
    /** 评分岗位(1-POS机) */
    @TableField(value = "post_type", updateStrategy = FieldStrategy.NEVER)
    protected Integer postType;
    /** 规则编码 */
    @TableField(value = "rule_code", updateStrategy = FieldStrategy.NEVER)
    protected String ruleCode;
    /** 规则名称 */
    @TableField(value = "rule_name", updateStrategy = FieldStrategy.NEVER)
    protected String ruleName;
    /** 规则说明(以{{param:value}}代表动态参数) */
    @TableField("rule_desc")
    protected String ruleDesc;
    /** 评分说明 */
    @TableField(value = "score_desc", updateStrategy = FieldStrategy.NEVER)
    protected String scoreDesc;
    /** 权重比例(%) */
    @TableField(value = "weight_ratio", updateStrategy = FieldStrategy.IGNORED)
    protected Integer weightRatio;
    /** 启用标识(0/1) */
    @TableField("enable_flag")
    protected Integer enableFlag;
    /** 修改人 */
    @TableField("update_user")
    protected String updateUser;
    /** 修改时间 */
    @TableField("update_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime updateTime;

    protected static final Pattern RULE_DESC_PARAM_PATTERN = Pattern.compile("\\{\\{(\\S+?):(.*?)\\}\\}");
    public Map<String, String> resolveRuleDescParam() {
        Matcher matcher = RULE_DESC_PARAM_PATTERN.matcher(getRuleDesc());
        Map<String, String> params = new LinkedHashMap<>();
        while (matcher.find()) {
            String paramName = matcher.group(1).trim();
            String paramValue = matcher.group(2).trim();
            params.put(paramName, paramValue);
        }
        return params;
    }
}
