package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName("ice_empe_score_pos")
public class EmpeScorePos implements Serializable {
    /** ID */
    @TableId("id")
    protected Long id;
    /** 员工ID */
    @TableField(value = "empe_id", updateStrategy = FieldStrategy.NEVER)
    protected Long empeId;
    /** 评分年份 */
    @TableField(value = "score_year", updateStrategy = FieldStrategy.NEVER)
    protected Integer scoreYear;
    /** 评分月份 */
    @TableField(value = "score_month", updateStrategy = FieldStrategy.NEVER)
    protected Integer scoreMonth;
    /** 员工评分 */
    @TableField("empe_score")
    protected Integer empeScore;
    /** 得分排名 */
    @TableField("score_rank")
    protected Integer scoreRank;
    /** 上期得分排名 */
    @TableField("last_score_rank")
    protected Integer lastScoreRank;
    /** 创建时间 */
    @TableField(value = "create_time", updateStrategy = FieldStrategy.NEVER)
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime createTime;

    public EmpeScorePos(long empeId, int year, int month) {
        this.setEmpeId(empeId);
        this.setScoreYear(year);
        this.setScoreMonth(month);
        this.setEmpeScore(0);
        this.setScoreRank(0);
        this.setLastScoreRank(0);
    }
}
