package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName("ice_empe_atte_record_aggr")
public class EmpeAtteRecordAggr implements Serializable {
    /** ID */
    @TableId("id")
    protected Long id;
    /** 考勤分组ID */
    @TableField("group_id")
    protected Long groupId;
    /** 考勤分组名称 */
    @TableField("group_name")
    protected String groupName;
    /** 考勤班次ID */
    @TableField("class_id")
    protected Long classId;
    /** 考勤班次名称 */
    @TableField("class_name")
    protected String className;
    /** 班次出勤时间 */
    @TableField("class_begin_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_TIME_HM_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_TIME_HM_PATTERN)
    protected LocalTime classBeginTime;
    /** 班次出勤时间 */
    @TableField("class_end_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_TIME_HM_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_TIME_HM_PATTERN)
    protected LocalTime classEndTime;
    /** 考勤计划ID */
    @TableField("plan_id")
    protected Long planId;
    /** 考勤计划日期 */
    @TableField("plan_date")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATE_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATE_PATTERN)
    protected LocalDate planDate;
    /** 车场ID */
    @TableField("park_id")
    protected Long parkId;
    /** 车场名称 */
    @TableField("park_name")
    protected String parkName;
    /** 员工ID */
    @TableField("empe_id")
    protected Long empeId;
    /** 员工姓名 */
    @TableField("empe_name")
    protected String empeName;

    /** 签到ID */
    @TableField("login_id")
    protected Long loginId;
    /** 打卡时间 */
    @TableField("login_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime loginTime;
    /** 打卡设备类型(1-POS机) */
    @TableField("login_dev_type")
    protected Integer loginDevType;
    /** 打卡设备号 */
    @TableField("login_dev_sn")
    protected String loginDevSn;
    /** 打卡经度 */
    @TableField("login_lon")
    protected Double loginLon;
    /** 打卡纬度 */
    @TableField("login_lat")
    protected Double loginLat;
    /** 打卡地址 */
    @TableField("login_addr")
    protected String loginAddr;
    /** 打卡结果(0-成功;1-迟到;2-早退;3-超范围;4-未打卡) */
    @TableField("login_result")
    protected Integer loginResult;

    /** 签到ID */
    @TableField("logout_id")
    protected Long logoutId;
    /** 打卡时间 */
    @TableField("logout_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime logoutTime;
    /** 打卡设备类型(1-POS机) */
    @TableField("logout_dev_type")
    protected Integer logoutDevType;
    /** 打卡设备号 */
    @TableField("logout_dev_sn")
    protected String logoutDevSn;
    /** 打卡经度 */
    @TableField("logout_lon")
    protected Double logoutLon;
    /** 打卡纬度 */
    @TableField("logout_lat")
    protected Double logoutLat;
    /** 打卡地址 */
    @TableField("logout_addr")
    protected String logoutAddr;
    /** 打卡结果(0-成功;1-迟到;2-早退;3-超范围;4-未打卡) */
    @TableField("logout_result")
    protected Integer logoutResult;

    /** 迟到时长(秒) */
    @TableField(value = "come_late_duration")
    protected Integer comeLateDuration;
    /** 早退时长(秒) */
    @TableField(value = "leave_early_duration")
    protected Integer leaveEarlyDuration;
    /** 在线时长(秒) */
    @TableField(value = "online_duration")
    protected Integer onlineDuration;
    /** 离线时长(秒) */
    @TableField(value = "offline_duration")
    protected Integer offlineDuration;
    /** 工作时长(秒) */
    @TableField(value = "work_duration")
    protected Integer workDuration;

    /** 创建时间 */
    @TableField("create_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime createTime;
}
