package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 巡检车设备表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-05-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_dev_inspection")
public class DevInspection implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 自增主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 设备编号
     */
    private String devCode;

    /**
     * 所属停车区id
     */
    private Integer parkId;

    /**
     * 设备型号（设备厂家型号表id）
     */
    private Integer devModel;

    /**
     * 设备序列号（MAC）
     */
    private String devSerialnumber;

    /**
     * 设备状态（1：正常，2：离线，3：故障，默认2）
     */
    private Integer devStatus;

    /**
     * 设备联系人
     */
    private String devOwner;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 纬度
     */
    private String latitude;

    /**
     * 泊位置信度阈值
     */
    private Integer thresholdSpaceCas;

    /**
     * 车牌置信度阈值
     */
    private Integer thresholdPlateCas;

    /**
     * 最后一次心跳时间（时间戳）
     */
    private Long heartbeatTime;

    /**
     * 添加时间
     */
    private Date createTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 描述信息
     */
    private String remark;
    /**
     * 设备状态
     */
    private Integer errorCode;
    /**
     * 终端设备接收信号得强度（例如：16）
     */
    private String signalValue;
    /**
     * 电量 单位：V
     */
    private String voltage;
    /**
     * 巡检车主程序的版本号
     */
    private String mainHostVersion;
    /**
     * 巡检车对接程序的版本号
     */
    private String abutHostVersion;
    /**
     * 巡检车算法框架库的版本号
     */
    private String jtJetsonServerSdkAlgVersion;
    /**
     * 巡检车算法核心库的版本号
     */
    private String peAnalyseAlgVersion;
    /**
     * 巡检车算法辅助库的版本号
     */
    private String laneRecognitionAlgVersion;
}
