package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 高位视频相机表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_dev_highvideo")
public class DevHighvideo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 设备编号
     */
    private String devCode;

    /**
     * 所属停车区id
     */
    private Integer parkId;

    /**
     * 设备杆编号
     */
    private String devRodnum;

    /**
     * 设备型号（设备厂家型号表id）
     */
    private Integer devModel;

    /**
     * 设备ip
     */
    private String devIpaddr;

    /**
     * 设备序列号（MAC）
     */
    private String devSerialnumber;

    /**
     * 设备状态（1：正常，2：离线，3：故障，默认1）
     */
    private Integer devStatus;

    /**
     * 设备位置
     */
    private String devAddr;

    /**
     * 中心坐标经度
     */
    private String centreLongitude;

    /**
     * 中心坐标维度
     */
    private String centreDimension;

    /**
     * 最后一次心跳时间（时间戳）
     */
    private Long heartbeatTime;

    /**
     * 注册标识(0-未注册;1-已注册)
     */
    private Integer registerFlag;
    /**
     * 签到用用户
     */
    private Long signInUser;
    /**
     * 签到用SIM卡
     */
    private Long signInSim;
    /**
     * 签到状态
     */
    private Integer signInStatus;

    /**
     * 添加时间
     */
    private Date createTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 描述信息
     */
    private String remark;
    /**
     * 签到用用户用户名
     */
    @TableField(exist = false)
    protected String signInUserName;
    /**
     * 签到用用户密码
     */
    @TableField(exist = false)
    protected String signInUserPwd;
}
