package com.icetech.city.road.domain.entity.dto;

import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.domain.table.MonthInfo;
import com.icetech.city.road.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.time.LocalTime;

@Getter
@Setter
@ToString(callSuper = true)
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
public class MonthInfoDto extends MonthInfo {
    protected Integer productId;
    protected String productName;
    protected Integer cardType;
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATE_PATTERN)
    protected LocalTime productStartDate;
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATE_PATTERN)
    protected LocalTime productEndDate;
    @TemporalFormat(pattern = DateUtils.DEFAULT_TIME_PATTERN)
    protected LocalTime productStartTime;
    @TemporalFormat(pattern = DateUtils.DEFAULT_TIME_PATTERN)
    protected LocalTime productEndTime;
}
