package com.icetech.city.road.domain.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * 车辆类型
 * @author wangzhiwei
 */
public interface CardTypeConstant {
    /** 非机动车 */
    Integer NON_VEHICLE = 0;
    /** 临时车 */
    Integer TEMP = 1;
    /** 月卡车 */
    Integer MONTH = 2;
    /** vip 车辆 */
    Integer VIP = 3;
    /** 特殊车辆 */
    Integer SPEC = 4;
    /** 白名单 */
    Integer WHITELIST = 5;
    /** 黑名单 */
    Integer BLACKLIST = 6;

    // 需放在类型字段后，否则无法获取静态字段值
    Map<Integer, String> map = new HashMap<Integer, String>() {{
        put(NON_VEHICLE, "非机动车");
        put(TEMP, "临时车");
        put(MONTH, "月卡车");
        put(VIP, "VIP车");
        put(SPEC, "特殊车辆");
        put(WHITELIST, "白名单");
        put(BLACKLIST, "黑名单");
    }};

    static String desc(Integer orderStatus){
        return map.get(orderStatus);
    }
}
