package com.icetech.city.road.component.exception;

import com.icetech.city.road.component.constant.CodeConstantsEnum;

public class ResponseBodyException extends RuntimeException {
    private String errCode;

    public ResponseBodyException(String errCode, String message) {
        super(message);
        this.errCode = errCode;
    }

    public ResponseBodyException(String errCode, String message, Throwable e) {
        super(message, e);
        this.errCode = errCode;
    }

    public ResponseBodyException(CodeConstantsEnum constant) {
        this(constant.getCode(), constant.getDesc());
    }

    public ResponseBodyException(CodeConstantsEnum constant, Throwable e) {
        this(constant.getCode(), constant.getDesc(), e);
    }

    public String getErrCode() {
        return this.errCode;
    }
}
