package com.icetech.city.road.app.undefined.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 路内下单携带的额外参数
 */
@Data
public class PayTo extends BasePrePayRes {
    /**
     * 路内下单的订单号
     */
    private List<PayToItem> payToItems;

    /**
     * 第三方交易流水号
     */
    private String outTradeNo;

    /**
     * 下单时间
     */
    private Long orderTime;

    /**
     * 支付方式（1：微信，2：支付宝）
     */
    private Integer payWay;

    /**
     * 支付来源（1：公众号）
     */
    private Integer payChannel;

    /**
     * 当前交易 实际支付的总金额(汇总交易)
     */
    private BigDecimal paidPrice;
    /**
     * 支付渠道1：微信直连，2：支付宝直连，3：兴业银行，4:农发行
     */
    private Integer payAisle;

    /**
     * 员工ID
     */
    private String employeeId;

    /**
     * 农商行流水号
     */
    private String ADBCoutTradeNo;

    /**
     * 商户单号
     */
    private String bankOrderId;
}
