/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.city.road.component.bean;

import com.icetech.city.road.component.bean.Response;
import com.icetech.city.road.component.constant.CodeConstants;
import com.icetech.city.road.component.constant.CodeConstantsEnum;
import com.icetech.city.road.component.exception.ResponseBodyException;
import com.icetech.city.road.utils.Slf4jUtils;
import java.util.Collection;
import lombok.Generated;

public class ObjectResponse<T>
extends Response {
    protected T data;
    protected String traceId = Slf4jUtils.getTraceId();

    public ObjectResponse(String code, String msg) {
        this(code, msg, null);
    }

    public ObjectResponse(String code, String msg, T data) {
        this.setCode(code);
        this.setMsg(msg);
        this.setData(data);
    }

    public static <T> ObjectResponse<T> instance(String code, T data) {
        return ObjectResponse.instance(code, CodeConstants.getName(code), data);
    }

    public static <T> ObjectResponse<T> instance(String code, String msg, T data) {
        return new ObjectResponse<T>(code, msg, data);
    }

    public static <T> ObjectResponse<T> instance(Response response) {
        return ObjectResponse.instance(response.getCode(), response.getMsg(), null);
    }

    public static <T> ObjectResponse<T> success() {
        return ObjectResponse.success(null);
    }

    public static <T> ObjectResponse<T> success(T data) {
        return ObjectResponse.instance("200", data);
    }

    public static <T> ObjectResponse<T> failed() {
        return ObjectResponse.failed(CodeConstantsEnum.ERROR);
    }

    public static <T> ObjectResponse<T> failed(ResponseBodyException exception) {
        return ObjectResponse.failed(exception.getErrCode(), exception.getMessage());
    }

    @Deprecated
    public static <T> ObjectResponse<T> failed(Response response) {
        return ObjectResponse.failed(response.getCode(), response.getMsg());
    }

    public static <T> ObjectResponse<T> failed(CodeConstantsEnum code) {
        return ObjectResponse.failed(code.getCode(), code.getDesc());
    }

    public static <T> ObjectResponse<T> failed(String code) {
        return ObjectResponse.failed(code, CodeConstants.getName(code));
    }

    public static <T> ObjectResponse<T> failed(String code, String msg) {
        return new ObjectResponse<T>(code, msg);
    }

    public static <T> ObjectResponse<T> returnNotFoundIfNull(T data) {
        if (data == null) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(data);
    }

    public static <T extends Collection<?>> ObjectResponse<T> returnNotFoundIfEmpty(T data) {
        return data != null && !data.isEmpty() ? ObjectResponse.success(data) : ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
    }

    public static ObjectResponse<Void> toAjax(int rows) {
        return rows > 0 ? ObjectResponse.success() : ObjectResponse.failed();
    }

    public static ObjectResponse<Void> toAjax(int rows, String code) {
        return rows > 0 ? ObjectResponse.success() : ObjectResponse.failed(code, "\u64cd\u4f5c\u5931\u8d25");
    }

    @Generated
    public T getData() {
        return this.data;
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public void setData(T data) {
        this.data = data;
    }

    @Generated
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @Override
    @Generated
    public String toString() {
        return "ObjectResponse(super=" + super.toString() + ", data=" + this.getData() + ", traceId=" + this.getTraceId() + ")";
    }

    @Generated
    public ObjectResponse() {
    }

    @Generated
    public ObjectResponse(T data, String traceId) {
        this.data = data;
        this.traceId = traceId;
    }
}

