package com.icetech.city.road.domain.table.plate.auth;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * 车主认证实体类
 *
 * @author wgq
 */
@Data
@TableName("ice_mp_user_plate_auth")
public class MpPlateAuth {
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 车牌号
     */
    private String plateNum;
    /**
     * 车主手机号
     */
    private String phone;
    /**
     * 用户名
     */
    private String userName;
    /**
     * 车主身份证
     */
    private String cardId;
    /**
     * 身份证人像图
     */
    private String cardImage;
    /**
     * 车头正面照
     */
    private String carImage;
    /**
     * 行驶证人像图
     */
    private String vehicleImage;
    /**
     * 公司营业执照
     */
    private String businessLicenseImage;
    /**
     * 认证时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date authTime;
    /**
     * 认证类型 0-个人，1-公司
     */
    private Integer authType;
    /**
     * 认证状态 0-认证失败，1-已认证，2-认证中，3-未认证
     */
    private Integer authStatus;
    /**
     * 认证人ID
     */
    private int authUserId;
    /**
     * 认证详情
     */
    private String authDetail;
    /**
     * 备注
     */
    private String remark;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
}
