package com.icetech.city.road.domain.table;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 日终支付票据
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("`znjt_billinfos`")
public class ZnjtBillInfo {
    /**
     * 自增主键ID
     */
    @TableId(value = "`id`")
    protected Long id;
    /**
     * 实际支付订单号(支付流水号)
     */
    @TableField(value = "`order_id`")
    protected String orderId;
    /**
     * 支付金额，单位：分
     */
    @TableField(value = "`paid_money`")
    protected Integer paidMoney;
    /**
     * 订单类型
     * 1：预付
     * 2：补费
     * 3：欠费补缴
     */
    @TableField(value = "`order_type`")
    protected Integer orderType;
    /**
     * 支付类型
     * 10-电子支付
     * 11-电子支付微信
     * 12-电子支付支付宝
     * 13-电子支付银联闪付
     * 20-现金类支付
     * 21-现金支付
     * 22-公交卡
     * 23-银联刷卡
     */
    @TableField(value = "`pay_type`")
    protected Integer payType;
    /**
     * 电子票据号
     */
    @TableField(value = "`bill_id`")
    protected String billId;
    /**
     * 电子票据号类型
     * 10-电子支付
     * 20-现金类支付
     */
    @TableField(value = "`bill_type`", exist = false)
    protected Integer billType;
    /**
     * 支付渠道
     * POS-线下POS机
     * APP-上海停车APP
     * WECHAT-微信小程序
     * ALIPAY-支付宝小程序
     */
    @TableField(value = "`channel`", exist = false)
    protected String channel;
    /**
     * 停车业务编号，一次完整停车为一个业务号，唯一(订单号)
     */
    @TableField(value = "`business_id`")
    protected String businessId;
    /**
     * 车牌号
     */
    @TableField(value = "`plate_id`")
    protected String plateId;
    /**
     * 车牌颜色
     */
    @TableField(value = "`plate_color`")
    protected Integer plateColor;
    /**
     * 协管单位执收码
     */
    @TableField(value = "`company_id`")
    protected String companyId;
    /**
     * 支付时间(Unix时间戳, 毫秒)
     */
    @TableField(value = "`data_time`")
    protected Long dataTime;
    /**
     * 创建时间
     */
    @TableField(value = "`create_time`")
    protected Date createTime;
}
