package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

import com.icetech.city.road.domain.entity.request.param.PosLoginRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 用户表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_saas_user")
public class SaasUser implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * iD (主健自增)
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 用户名
     */
    private String username;

    /**
     * 密码
     */
    private String password;

    /**
     * 真实姓名
     */
    private String name;

    /**
     * 联系方式
     */
    private String phone;

    /**
     * 状态（0正常、1冻结)
     */
    private Integer status;

    /**
     * 系统自动添加 0人工录入，1系统自动生成
     */
    private Integer sysAdd;

    /**
     * 所属机构
     */
    private Integer institutionId;

    /**
     * 角色ID
     */
    private Integer roleId;

    /**
     * 是否删除（0正常、1删除）
     */
    private Boolean isDelete;

    /**
     * 注册标识(0-未注册;1-已注册)
     */
    protected Integer registerFlag;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 添加时间
     */
    private LocalDateTime addTime;

    /**
     * 最后登录时间
     */
    private LocalDateTime lastLogin;

    /**
     * 最后登录ip
     */
    private String lastIp;

    /**
     * 用户岗位
     */
    private String userPost;

    /**
     * 角色名称_路内平台的角色
     */
    private String roadroleName;

    /**
     * 角色名称_场库平台的角色
     */
    private String parkroleName;

    /**
     * 角色 _路内角色的Id
     */
    private Integer roadroleId;
}
