package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 停车行为异常表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-05-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_parking_exception")
public class ParkingException implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 自增主健id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 所属道路id
     */
    private Integer parkId;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 泊位id
     */
    private Integer berthId;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 告警来源(0-系统平台;1-高位视频;2-地磁;3-pos机;4-人工手动;5-巡检车)
     */
    private Integer alarmSource;
    /**
     * 告警类型(1-压线;2-跨位;3-逆向;4-违停)
     */
    private Integer alarmType;
    /**
     * 告警原因
     */
    private String alarmReason;
    /**
     * 告警描述
     */
    private String alarmDesc;
    /**
     * 告警图片
     */
    private String alarmImage;

    /**
     * 添加时间
     */
    private Date createTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 描述信息
     */
    private String remark;


}
